//
//  TTTGameView.m
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 9/4/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import "TTTGameView.h"
#import "TTTBoard.h"

@implementation TTTGameView

    - (void) setGameViewComponents :(TTTBoard *) theBoard :(UITextField *) theStatusView
                               :(UITextField *) theSessionScoresView {
        gameBoard = theBoard;
        statusTextField = theStatusView;
        sessionScoresTextField = theSessionScoresView;
    }
    
    - (void) setGameStatus :(NSString *) message{
        [statusTextField setText:message];
    }
    
    - (void) showScores :(NSString *) player1Name :(int) player1Score
                        :(NSString *) player2Name :(int) player2Score {
    
        [sessionScoresTextField setText:[[NSArray arrayWithObjects :player1Name,
                                                              @":",
                                                              [NSNumber numberWithInt:player1Score],
                                                              @"....",
                                                              player2Name,
                                                              @":",
                                                              [NSNumber numberWithInt:player2Score],
                                                              nil]
                                    componentsJoinedByString:@" "]];
    }
    
    - (void) placeSymbol :(int) x :(int) y {
        [gameBoard invalidateBlock :x :y];
    }

    - (void) redraw{
        [gameBoard setNeedsDisplay];
    }

    - (void) promptToProceed :(TTTGameSessionViewController *) GameViewController {
        UIAlertView *alert = [[UIAlertView alloc] init];
        [alert setTitle:@"Game Over!"];
        [alert setMessage:@"Play Another Game?"];
        [alert addButtonWithTitle:@"Yes"];
        [alert addButtonWithTitle:@"No"];
        [alert setDelegate:GameViewController];
        [alert show];
    }

@end
